####################################################
### code chunk number : Simulations: Consistency
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
ptm = proc.time()

## initialization
mu = 0               ## hyperparameter
alpha = 3            ## hyperparameter
beta = 1             ## hyperparameter
# N = 10^(1:5); N      ## sample size
N = 1e4 * 2^c(0, 1, 2, 3, 4, 5); N      ## sample size
L_N = length(N); L_N ## the length of N
M = 100              ## number of simulations, to calculate the probability

set.seed(2) 
n = N[L_N]
X = matrix(0, nrow = M, ncol = n)
for (m in 1:M){
	theta_m = 1 / rgamma(n = n, shape = alpha, scale = beta)
	X[m, ] = rnorm(n = n, mean = mu, sd = sqrt(theta_m))
}

## Histogram,
hist(X[1, ], probability = TRUE,
    main = paste("Histogram of" , "X[1, ]"), 
    xlab = "x")
lines(density(X[1, ]), col = "blue")

F1 = F2 = matrix(0, nrow = L_N, ncol = 3)
colnames(F1) = c("mu_1", "alpha_1", "beta_1")
colnames(F2) = c("mu_2", "alpha_2", "beta_2")
mu_1 = alpha_1 = beta_1 = matrix(0, nrow = L_N, ncol = M)
mu_2 = alpha_2 = beta_2 = matrix(0, nrow = L_N, ncol = M)
for (j in 1:L_N){
	cat("\n"); print(paste("In this cycle, j = ", j, sep = "")); cat("\n")
	n = N[j]; n
	mu_1_alpha_1_beta_1 = mu_2_alpha_2_beta_2 = matrix(0, nrow = M, ncol = 3)
	for (m in 1:M){
		cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
		
		## Note that x is the sample, it is used in the calculation of the MLEs. 
		## See moment_fun().
		x = X[m, 1:n]
		mu_1_alpha_1_beta_1[m, ] = Moment_estimators(x)
		cat("mu_1_alpha_1_beta_1[m, ] \n"); print(mu_1_alpha_1_beta_1[m, ]); cat("\n")
		
		## The MLE is very sensitive to the initial guess. 
		## The moment estimator is usually a good initial guess.
		res_Newtons_m = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1[m, ], x = x)
		mu_2_alpha_2_beta_2[m, ] = res_Newtons_m$root
		cat("mu_2_alpha_2_beta_2[m, ] \n"); print(mu_2_alpha_2_beta_2[m, ]); cat("\n")
	}
	mu_1[j, ]    = mu_1_alpha_1_beta_1[, 1]
	alpha_1[j, ] = mu_1_alpha_1_beta_1[, 2]
	beta_1[j, ]  = mu_1_alpha_1_beta_1[, 3]
	
	mu_2[j, ]    = mu_2_alpha_2_beta_2[, 1]
	alpha_2[j, ] = mu_2_alpha_2_beta_2[, 2]
	beta_2[j, ]  = mu_2_alpha_2_beta_2[, 3]
}
Abs_mu_1    = abs(mu_1 - matrix(mu, nrow = L_N, ncol = M)); ## round(Abs_mu_1, 3)
Abs_alpha_1 = abs(alpha_1 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_1, 3)
Abs_beta_1  = abs(beta_1 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_1, 3)

Abs_mu_2    = abs(mu_2 - matrix(mu, nrow = L_N, ncol = M)); ## round(Abs_mu_2, 3)
Abs_alpha_2 = abs(alpha_2 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_2, 3)
Abs_beta_2  = abs(beta_2 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_2, 3)

## epsilon = 1, 0.5, 0.1
## moment estimator
epsilon = 1
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)
A1 = F1

epsilon = 0.5
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)
A2 = F1

epsilon = 0.1
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)
A3 = F1

## MLE
epsilon = 1
F2[, 1] = apply((Abs_mu_2    >= epsilon), 1, mean)
F2[, 2] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 3] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)
A4 = F2

epsilon = 0.5
F2[, 1] = apply((Abs_mu_2    >= epsilon), 1, mean)
F2[, 2] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 3] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)
A5 = F2

epsilon = 0.1
F2[, 1] = apply((Abs_mu_2    >= epsilon), 1, mean)
F2[, 2] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 3] = apply((Abs_beta_2  >= epsilon), 1, mean)
round(F2, 3)
A6 = F2

A = cbind(rbind(A1, A2, A3), rbind(A4, A5, A6))
A = format(round(A, 2), nsmall = 2); A
Generate_Matrix_Latex(A)

## about 30.19s for N = 1e4 * 2^c(0, 1, 2, 3, 4, 5)
time_new = proc.time() - ptm; time_new

